import * as banterpb from '/m/banter/pb/banter_pb.js';
import { UpdatingControlPanel } from '/tk.js';
import { BanterPlayground, help } from './banter_playground.js';
class BanterMessages extends UpdatingControlPanel {
    _table;
    _button;
    _editor;
    _rows = [];
    constructor(cfg) {
        super({ title: 'Messages', help, data: cfg });
        this.innerHTML = `
<table></table>
<button> + </button>
`;
        this._table = this.querySelector('table');
        this._button = this.querySelector('button');
        this._button.addEventListener('click', () => this._handleNew());
        this._editor = new BanterPlayground(cfg);
        this.appendChild(this._editor);
    }
    update(cfg) {
        this._table.innerHTML = `
<tr>
    <th>Command</th>
    <th>Text</th>
    <th>Enabled</th>
    <th>Random</th>
    <th>Edit</th>
</tr>
`;
        this._rows = cfg.banters.map((banter, i) => {
            let row = new BanterRow();
            row.banter = banter;
            row.onedit = () => this._editor.edit(banter);
            row.onsave = (banter) => {
                let cfg = this.last.clone();
                cfg.banters[i] = banter;
                this._save(cfg);
            };
            row.ondelete = () => this._delete(i);
            return row;
        });
        this._rows.forEach((row) => {
            this._table.appendChild(row);
        });
        this._editor.close();
    }
    _handleNew() {
        this._editor.edit(new banterpb.Banter());
    }
    _delete(i) {
        let cfg = this.last;
        if (i < 0 || i >= cfg.banters?.length) {
            return;
        }
        let banter = cfg.banters[i];
        if (!confirm(`Delete ${banter.command}?`)) {
            return;
        }
        cfg = cfg.clone();
        cfg.banters.splice(i, 1);
        this._save(cfg);
    }
    _save(cfg) {
        if (this._rows.find((row) => !row.isValid)) {
            return;
        }
        this.save(cfg);
    }
}
customElements.define('banter-messages', BanterMessages, { extends: 'fieldset' });
class BanterRow extends HTMLTableRowElement {
    _input_command;
    _input_text;
    _check_enabled;
    _check_random;
    _button_edit;
    _button_delete;
    _orig;
    onedit = () => { };
    onsave = () => { };
    ondelete = () => { };
    constructor() {
        super();
        this.innerHTML = `
<td><input id="command" type="text" size="16" disabled /></td>
<td><input id="text" type="text" size="48" disabled /></td>
<td><input id="enabled" type="checkbox" /></td>
<td><input id="random" type="checkbox" /></td>
<td>
    <button id="btn-edit">Edit</button>
    <button id="btn-delete">Delete</button>
</td>
`;
        this._input_command = this.querySelector('#command');
        this._input_text = this.querySelector('#text');
        this._check_enabled = this.querySelector('#enabled');
        this._check_random = this.querySelector('#random');
        this._button_edit = this.querySelector('#btn-edit');
        this._button_edit.onclick = () => this.onedit();
        this._button_delete = this.querySelector('#btn-delete');
        this._button_delete.onclick = () => this.ondelete();
        this._check_enabled.addEventListener('change', () => this.save());
        this._check_random.addEventListener('change', () => this.save());
    }
    set banter(banter) {
        this._orig = banter.clone();
        this._input_command.value = banter.command;
        this._input_text.value = banter.text;
        this._check_enabled.checked = !banter.disabled;
        this._check_random.checked = banter.random;
        if (banter.text.includes('{{')) {
            this._check_random.disabled = true;
        }
    }
    save() {
        let newBanter = this._orig.clone();
        newBanter.command = this._input_command.value;
        newBanter.text = this._input_text.value;
        newBanter.random = this._check_random.checked;
        newBanter.disabled = !this._check_enabled.checked;
        this.onsave(newBanter);
    }
    isValid() {
        return true;
    }
}
customElements.define('banter-row', BanterRow, { extends: 'tr' });
export { BanterMessages };
