import * as buspb from "/pb/bus/bus_pb.js";
import { bus, enumName } from "/bus.js";
import { requests } from "/m/twitch/pb.js";
let tryImport = (resolve) => import('/m/twitch/pb.js')
    .then((mod) => {
    resolve(new Twitch(mod));
}).catch(() => {
    setTimeout(() => { tryImport(resolve); }, 500);
});
let twitch = new Promise((resolve) => {
    tryImport(resolve);
});
class Twitch {
    TOPIC_REQUEST = "";
    static requests;
    constructor(mod) {
        this.TOPIC_REQUEST = enumName(mod.BusTopics, mod.BusTopics.TWITCH_REQUEST);
        Twitch.requests = mod.requests;
    }
    getUser(id) {
        return bus.sendAnd(new buspb.BusMessage({
            topic: this.TOPIC_REQUEST,
            type: requests.MessageTypeRequest.TYPE_REQUEST_GET_USER_REQ,
            message: new requests.GetUserRequest({
                profile: 'selfdrivingcarp',
                login: id,
            }).toBinary(),
        })).then((reply) => {
            return requests.GetUserResponse.fromBinary(reply.message);
        });
    }
}
export { twitch };
