import { bus, enumName } from "/bus.js";
import * as buspb from "/pb/bus/bus_pb.js";
import * as roscopb from "/m/rosco/pb/rosco_pb.js";
import { ValueUpdater } from "/vu.js";
const TOPIC_REQUEST = enumName(roscopb.BusTopic, roscopb.BusTopic.ROSCO_REQUEST);
const TOPIC_COMMAND = enumName(roscopb.BusTopic, roscopb.BusTopic.ROSCO_COMMAND);
class Cfg extends ValueUpdater {
    constructor() {
        super(new roscopb.Config());
    }
    refresh() {
        bus.sendAnd(new buspb.BusMessage({
            topic: TOPIC_REQUEST,
            type: roscopb.MessageTypeRequest.CONFIG_GET_REQ,
            message: new roscopb.ConfigGetRequest().toBinary(),
        })).then((reply) => {
            if (reply.error) {
                throw reply.error;
            }
            let cgResp = roscopb.ConfigGetResponse.fromBinary(reply.message);
            this.update(cgResp.config);
        });
    }
    async save(cfg) {
        let csr = new roscopb.ConfigSetRequest();
        csr.config = cfg;
        let msg = new buspb.BusMessage();
        msg.topic = TOPIC_COMMAND;
        msg.type = roscopb.MessageTypeCommand.CONFIG_SET_REQ;
        msg.message = csr.toBinary();
        return bus.sendAnd(msg)
            .then((reply) => {
            let csResp = roscopb.ConfigSetResponse.fromBinary(reply.message);
            this.update(csResp.config);
        });
    }
}
class Scripts extends ValueUpdater {
    _cfg;
    constructor(cfg) {
        super({});
        this._cfg = cfg;
        this._cfg.subscribe((cfg) => {
            this.update(cfg.scripts);
        });
    }
    async save(scripts) {
        let cfg = this._cfg.last.clone();
        cfg.scripts = scripts;
        return this._cfg.save(cfg);
    }
}
class Controller {
    _cfg;
    _ready;
    scriptEdit;
    testTarget = '';
    scripts;
    constructor() {
        this._cfg = new Cfg();
        this.scriptEdit = new ValueUpdater({ id: 0, v: undefined });
        this.scripts = new Scripts(this._cfg);
        this._ready = new Promise((resolve) => {
            bus.waitForTopic(TOPIC_REQUEST, 5000)
                .then(() => {
                this._cfg.refresh();
                let unsub = this._cfg.subscribe(() => {
                    resolve();
                    unsub();
                });
            });
        });
    }
    get cfg() {
        return this._cfg;
    }
    ready() {
        return this._ready;
    }
    sendOSC(address, osc) {
        let script = new roscopb.Script({
            name: 'one-shot',
            actions: [new roscopb.ScriptAction({
                    address: address,
                    type: roscopb.ScriptActionType.ActionTypeSet,
                    values: [osc],
                })],
        });
        this.runScript(script);
    }
    runScript(idOrScript, target = '') {
        if (!(target || this.testTarget)) {
            return;
        }
        let srr = new roscopb.ScriptRunRequest({
            target: target ? target : this.testTarget,
        });
        if (typeof idOrScript === "number") {
            srr.scriptId = idOrScript;
        }
        else {
            srr.script = idOrScript;
        }
        bus.sendAnd(new buspb.BusMessage({
            topic: TOPIC_REQUEST,
            type: roscopb.MessageTypeRequest.SCRIPT_RUN_REQ,
            message: srr.toBinary(),
        })).catch((e) => console.log(`ERROR requesting script run: ${e}`));
    }
}
export { Cfg, Controller };
